/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import com.example.worldresetmod.WorldResetMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.file.Files;

public class EnhancedAdminDeleteUtil {
    public static boolean performEnhancedAdminDelete(String filePath) {
        WorldResetMod.logger.info("=== Enhanced Admin Delete for: " + filePath + " ===");
        try {
            File targetFile = new File(filePath);
            if (!targetFile.exists()) {
                WorldResetMod.logger.info("File doesn't exist, considering as success");
                return true;
            }
            WorldResetMod.logger.info("Method 1: Standard delete attempt");
            if (targetFile.delete()) {
                WorldResetMod.logger.info("Standard delete succeeded");
                return true;
            }
            WorldResetMod.logger.info("Method 2: NIO delete attempt");
            try {
                Files.deleteIfExists(targetFile.toPath());
                if (!targetFile.exists()) {
                    WorldResetMod.logger.info("NIO delete succeeded");
                    return true;
                }
            }
            catch (Exception e) {
                WorldResetMod.logger.warn("NIO delete failed: " + e.getMessage());
            }
            WorldResetMod.logger.info("Method 3: Modify attributes and delete");
            targetFile.setWritable(true);
            targetFile.setReadable(true);
            targetFile.setExecutable(true);
            if (targetFile.delete()) {
                WorldResetMod.logger.info("Attribute modification delete succeeded");
                return true;
            }
            WorldResetMod.logger.info("Method 4: Windows force delete");
            return EnhancedAdminDeleteUtil.performWindowsForceDelete(filePath);
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Enhanced admin delete failed", (Throwable)e);
            return false;
        }
    }

    private static boolean performWindowsForceDelete(String filePath) {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "del /F /Q \"" + filePath + "\"");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            int exitCode = process.waitFor();
            WorldResetMod.logger.info("Windows force delete - Exit code: " + exitCode);
            WorldResetMod.logger.info("Output: " + output.toString().trim());
            File file = new File(filePath);
            boolean deleted = !file.exists();
            return deleted;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Windows force delete failed: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestUACElevation(String filePath) {
        boolean bl;
        WorldResetMod.logger.info("=== UAC Elevation Request for: " + filePath + " ===");
        String vbsScriptPath = EnhancedAdminDeleteUtil.createUACElevationScript(filePath);
        if (vbsScriptPath == null) {
            WorldResetMod.logger.error("Failed to create UAC elevation script");
            return false;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("wscript.exe", "\"" + vbsScriptPath + "\"");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            int exitCode = process.waitFor();
            WorldResetMod.logger.info("UAC elevation script - Exit code: " + exitCode);
            File file = new File(filePath);
            boolean deleted = !file.exists();
            WorldResetMod.logger.info("UAC elevation deletion result: " + deleted);
            bl = deleted;
            new File(vbsScriptPath).delete();
        }
        catch (Throwable throwable) {
            try {
                new File(vbsScriptPath).delete();
                throw throwable;
            }
            catch (Exception e) {
                WorldResetMod.logger.error("UAC elevation request failed", (Throwable)e);
                return false;
            }
        }
        return bl;
    }

    private static String createUACElevationScript(String filePath) {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            String scriptPath = tempDir + "\\UACElevation_" + System.currentTimeMillis() + ".vbs";
            String vbsContent = "Set UAC = CreateObject(\"Shell.Application\")\nUAC.ShellExecute \"cmd.exe\", \"/c del /F /Q \\\"" + filePath + "\\\"\", \"\", \"runas\", 1\nWScript.Quit 0";
            FileWriter writer = new FileWriter(scriptPath);
            writer.write(vbsContent);
            writer.close();
            return scriptPath;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Failed to create VBS script: " + e.getMessage());
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isFileLocked(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

